/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.beekeeper;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBeekeeper;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobBeekeeper;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIInteract;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkBeekeeper
extends AbstractEntityAIInteract<JobBeekeeper, BuildingBeekeeper> {
    private static final int NUM_OF_ANIMALS_TO_BREED = 2;
    private static final int BEES_PER_LEVEL = 3;
    private static final int NUM_OF_FLOWERS_TO_BREED = 2;
    private static final int NUM_OF_WANTED_FLOWERS = 16;
    private static final double EXP_PER_HARVEST = 5.0;
    private static final int DISTANCE_TO_BREED = 10;
    private static final int HIVE_BEE_RADIUS = 22;
    private static final int DECIDING_DELAY = 40;
    private static final int NO_ANIMALS_DELAY = 100;
    private static final int NO_HIVES_DELAY = 100;
    private static final int NO_FLOWERS_DELAY = 100;
    private static final int BREEDING_DELAY = 40;
    private boolean lastHarvestedBottle = false;

    public EntityAIWorkBeekeeper(@NotNull JobBeekeeper job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, this::prepareForHerding, 1), new AITarget((IAIState)AIWorkerState.DECIDE, this::decideWhatToDo, 1), new AITarget((IAIState)AIWorkerState.HERDER_BREED, this::breedAnimals, 1), new AITarget((IAIState)AIWorkerState.BEEKEEPER_HARVEST, this::harvestHoney, 20));
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 5;
    }

    private boolean hasMaxAnimals(List<BeeEntity> allBees) {
        int maxAnimals;
        int numOfBeesInHive = this.getBeesInHives();
        int numOfAnimals = allBees.size();
        return numOfAnimals + numOfBeesInHive >= (maxAnimals = ((BuildingBeekeeper)this.building).getBuildingLevel() * 3);
    }

    private int getBeesInHives() {
        return ((BuildingBeekeeper)this.building).getHives().stream().map(arg_0 -> ((World)this.world).func_175625_s(arg_0)).filter(Objects::nonNull).map(BeehiveTileEntity.class::cast).mapToInt(BeehiveTileEntity::func_226971_j_).sum();
    }

    private IAIState prepareForHerding() {
        this.setDelay(40);
        if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honey") && this.checkForToolOrWeapon(ToolType.SHEARS)) {
            return this.getState();
        }
        if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honeycomb")) {
            this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((IItemProvider)Items.field_151069_bo));
        }
        return AIWorkerState.DECIDE;
    }

    private IAIState startWorkingAtOwnBuilding() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.worker.goingtohut")});
        if (this.walkToBuilding()) {
            this.setDelay(2);
            return this.getState();
        }
        return AIWorkerState.PREPARING;
    }

    private IAIState decideWhatToDo() {
        this.setDelay(40 + (99 / this.getSecondarySkillLevel() - 1));
        Set<BlockPos> hives = ((BuildingBeekeeper)this.building).getHives();
        if (hives.isEmpty()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.beekeeper.messagenohives"), ChatPriority.BLOCKING));
            this.setDelay(100);
            return AIWorkerState.DECIDE;
        }
        ItemListModule flowersModule = ((BuildingBeekeeper)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers"));
        if (flowersModule.getList().isEmpty() && ((BoolSetting)((BuildingBeekeeper)this.building).getSetting(BuildingBeekeeper.BREEDING)).getValue()) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.beekeeper.noflowers"), ChatPriority.BLOCKING));
            this.setDelay(100);
            return AIWorkerState.DECIDE;
        }
        for (BlockPos pos2 : hives) {
            if (this.world.func_180495_p(pos2).func_177230_c() instanceof BeehiveBlock) continue;
            ((BuildingBeekeeper)this.building).removeHive(pos2);
        }
        Optional<BlockPos> hive = ((BuildingBeekeeper)this.building).getHives().stream().filter(pos -> BeehiveTileEntity.func_226964_a_((BlockState)this.world.func_180495_p(pos)) >= 5).findFirst();
        if (hive.isPresent()) {
            return AIWorkerState.BEEKEEPER_HARVEST;
        }
        List<BeeEntity> bees = EntityAIWorkBeekeeper.searchForAnimals(this.world, (BuildingBeekeeper)this.building);
        JobBeekeeper job = this.worker.getCitizenJobHandler().getColonyJob(JobBeekeeper.class);
        if (bees.isEmpty()) {
            if (this.getBeesInHives() <= 0) {
                job.tickNoBees();
                if (job.checkForBeeInteraction()) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.beekeeper.messagenobees"), ChatPriority.BLOCKING));
                }
            } else {
                job.resetCounter();
            }
            this.setDelay(100);
            return AIWorkerState.DECIDE;
        }
        job.resetCounter();
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.deciding")});
        if (this.isReadyForBreeding()) {
            return AIWorkerState.HERDER_BREED;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState breedAnimals() {
        this.setDelay(40);
        List<BeeEntity> animals = EntityAIWorkBeekeeper.searchForAnimals(this.world, (BuildingBeekeeper)this.building);
        AnimalEntity animalOne = animals.stream().filter(animal -> !animal.func_70631_g_()).findAny().orElse(null);
        if (animalOne == null) {
            return AIWorkerState.DECIDE;
        }
        AnimalEntity animalTwo = animals.stream().filter(animal -> {
            float range = animal.func_70032_d((Entity)animalOne);
            boolean isAnimalOne = animalOne.equals(animal);
            return animal.func_70874_b() == 0 && range <= 10.0f && !isAnimalOne;
        }).findAny().orElse(null);
        if (animalTwo == null) {
            return AIWorkerState.DECIDE;
        }
        if (!this.equipBreedItem(Hand.MAIN_HAND)) {
            return AIWorkerState.START_WORKING;
        }
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.herder.breeding")});
        this.breedTwoAnimals(animalOne, animalTwo);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.DECIDE;
    }

    private IAIState harvestHoney() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.harvestinghives")});
        List hives = ((BuildingBeekeeper)this.building).getHives().stream().filter(pos -> BeehiveTileEntity.func_226964_a_((BlockState)this.world.func_180495_p(pos)) >= 5).collect(Collectors.toList());
        if (hives.isEmpty()) {
            return AIWorkerState.DECIDE;
        }
        if (((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honeycomb") || ((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.both") && this.lastHarvestedBottle ? !this.equipTool(Hand.MAIN_HAND, ToolType.SHEARS) : !this.equipItem(Hand.MAIN_HAND, new ItemStack((IItemProvider)Items.field_151069_bo))) {
            return AIWorkerState.PREPARING;
        }
        BlockPos hive = (BlockPos)hives.get(0);
        if (!this.world.func_180495_p(hive).func_235714_a_((ITag)BlockTags.field_226151_aa_)) {
            ((BuildingBeekeeper)this.building).removeHive(hive);
            return AIWorkerState.PREPARING;
        }
        if (this.walkToBlock(hive)) {
            return this.getState();
        }
        this.worker.func_184609_a(Hand.MAIN_HAND);
        ItemStack itemStack = this.worker.func_184614_ca();
        if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honey") && ItemStackUtils.isTool(itemStack, ToolType.SHEARS)) {
            this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
            for (ItemStack stackItem : Compatibility.getCombsFromHive(hive, this.world, this.getHoneycombsPerHarvest())) {
                InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(stackItem, this.worker.getItemHandlerCitizen());
            }
            this.world.func_175656_a(hive, (BlockState)this.world.func_180495_p(hive).func_206870_a((Property)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf(0)));
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.lastHarvestedBottle = false;
        } else if (!((BuildingBeekeeper)this.building).getHarvestTypes().equals("com.minecolonies.core.apiary.setting.honeycomb") && itemStack.func_77973_b() == Items.field_151069_bo) {
            int i;
            for (i = 0; i < this.getHoneyBottlesPerHarvest() && !itemStack.func_190926_b(); ++i) {
                itemStack.func_190918_g(1);
            }
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(new ItemStack((IItemProvider)Items.field_226638_pX_, i), this.worker.getItemHandlerCitizen());
            this.world.func_175656_a(hive, (BlockState)this.world.func_180495_p(hive).func_206870_a((Property)BlockStateProperties.field_227036_ao_, (Comparable)Integer.valueOf(0)));
            this.worker.getCitizenExperienceHandler().addExperience(5.0);
            this.lastHarvestedBottle = true;
        }
        int dex = this.getPrimarySkillLevel();
        if ((50.0 - (double)dex / 99.0 * 50.0) / 100.0 > this.worker.func_70681_au().nextDouble()) {
            List bees = ((BeehiveTileEntity)this.world.func_175625_s(hive)).func_226965_a_(this.world.func_180495_p(hive), BeehiveTileEntity.State.EMERGENCY);
            bees.stream().filter(entity -> entity instanceof BeeEntity).map(entity -> (BeeEntity)entity).filter(bee -> this.worker.func_213303_ch().func_72436_e(bee.func_213303_ch()) <= 16.0).forEach(bee -> {
                bee.func_230260_a__(400 + this.worker.func_70681_au().nextInt(400));
                bee.func_70604_c((LivingEntity)this.worker);
            });
        }
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.START_WORKING;
    }

    public boolean walkingToAnimal(AnimalEntity animal) {
        if (animal != null) {
            this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.herder.goingtoanimal")});
            return this.walkToBlock(new BlockPos(animal.func_213303_ch()));
        }
        return false;
    }

    private boolean isReadyForBreeding() {
        boolean canBreed;
        if (!((BoolSetting)((BuildingBeekeeper)this.building).getSetting(BuildingBeekeeper.BREEDING)).getValue()) {
            return false;
        }
        ItemListModule flowersModule = ((BuildingBeekeeper)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers"));
        List<BeeEntity> bees = EntityAIWorkBeekeeper.searchForAnimals(this.world, (BuildingBeekeeper)this.building);
        int breedableAnimals = (int)bees.stream().filter(animal -> animal.func_70874_b() == 0).count();
        boolean bl = canBreed = !this.hasMaxAnimals(bees) && breedableAnimals >= 2;
        if (canBreed) {
            int flowerCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> flowersModule.isItemInList(new ItemStorage((ItemStack)stack))) + InventoryUtils.getCountFromBuilding((IBuilding)this.building, flowersModule.getList());
            if (flowerCount < 2 && !((BuildingBeekeeper)this.building).hasWorkerOpenRequestsOfType(this.worker.getCitizenData().getId(), TypeToken.of(StackList.class))) {
                this.worker.getCitizenData().createRequestAsync(new StackList(flowersModule.getList().stream().map(ItemStorage::getItemStack).peek(stack -> stack.func_190920_e(16)).collect(Collectors.toList()), "com.minecolonies.coremod.request.flowers", 16, 2));
                return false;
            }
            return flowerCount >= 2;
        }
        return false;
    }

    private void breedTwoAnimals(AnimalEntity animalOne, AnimalEntity animalTwo) {
        ArrayList<AnimalEntity> animalsToBreed = new ArrayList<AnimalEntity>();
        animalsToBreed.add(animalOne);
        animalsToBreed.add(animalTwo);
        for (AnimalEntity animal : animalsToBreed) {
            if (animal.func_70880_s() || this.walkingToAnimal(animal)) continue;
            animal.func_146082_f(null);
            this.worker.func_184609_a(Hand.MAIN_HAND);
            InventoryUtils.reduceStackInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), this.worker.func_184614_ca());
        }
    }

    public boolean equipTool(Hand hand, ToolType toolType) {
        if (this.getToolSlot(toolType) != -1) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getToolSlot(toolType));
            return true;
        }
        return false;
    }

    private int getToolSlot(ToolType toolType) {
        int slot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), toolType, 0, ((BuildingBeekeeper)this.building).getMaxToolLevel());
        if (slot == -1) {
            this.checkForToolOrWeapon(toolType);
        }
        return slot;
    }

    public boolean equipItem(Hand hand, ItemStack itemStack) {
        if (this.checkIfRequestForItemExistOrCreateAsync(itemStack)) {
            this.worker.getCitizenItemHandler().setHeldItem(hand, this.getItemSlot(itemStack.func_77973_b()));
            return true;
        }
        return false;
    }

    public boolean equipBreedItem(Hand hand) {
        if (this.checkIfRequestForTagExistOrCreateAsync((ITag<Item>)ItemTags.field_226159_I_, 2)) {
            ItemListModule flowersModule = ((BuildingBeekeeper)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers"));
            this.worker.getCitizenItemHandler().setHeldItem(hand, InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), stack -> flowersModule.isItemInList(new ItemStorage((ItemStack)stack))));
            return true;
        }
        return false;
    }

    public int getItemSlot(Item item) {
        return InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getInventory(), item);
    }

    public static List<BeeEntity> searchForAnimals(World world, BuildingBeekeeper ownBuilding) {
        if (ownBuilding == null) {
            return new ArrayList<BeeEntity>();
        }
        return ownBuilding.getHives().stream().map(AxisAlignedBB::new).map(aabb -> aabb.func_186662_g(22.0)).map(aabb -> world.func_225317_b(BeeEntity.class, aabb)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private int getHoneyBottlesPerHarvest() {
        return 1;
    }

    private int getHoneycombsPerHarvest() {
        return 3;
    }

    @Override
    public Class<BuildingBeekeeper> getExpectedBuildingClass() {
        return BuildingBeekeeper.class;
    }
}

